/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.google.common.hash.Hashing;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class RouteUtils {
    private static final Logger logger = LoggerFactory.getLogger(RouteUtils.class);
    private static final PathPatternParser PATH_PATTERN_PARSER = PathPatternParser.defaultInstance;
    private static final String PATH_VARIABLE_NAME_PREFIX = "variable";

    public static String hash(String path) {
        path = RouteUtils.reRenderPath(path);
        logger.info("route.RenderPath = {}", (Object)path);
        String hash = Hashing.sha1().newHasher().putString((CharSequence)path, StandardCharsets.UTF_8).hash().toString();
        return hash;
    }

    public static String reRenderPath(String path) {
        PathContainer pathContainer = PathContainer.parsePath((String)path);
        PathPattern pathPattern = PATH_PATTERN_PARSER.parse(path);
        PathPattern.PathMatchInfo pathMatchInfo = pathPattern.matchAndExtract(pathContainer);
        if (pathMatchInfo == null) {
            return path;
        }
        Map pathVariables = pathMatchInfo.getUriVariables();
        HashMap variables = new HashMap(pathVariables.size());
        List pathEntries = null;
        if (!pathVariables.isEmpty()) {
            logger.debug("route.path.variables: {} ", (Object)pathVariables);
            Map.Entry[] pathEntriesArray = new Map.Entry[path.length()];
            for (Map.Entry entry : pathVariables.entrySet()) {
                int index = StringUtils.indexOf((CharSequence)path, (CharSequence)((CharSequence)entry.getValue()));
                logger.debug("route.path entry.value = {}, index = {}", entry.getValue(), (Object)index);
                pathEntriesArray[index] = entry;
            }
            pathEntries = Arrays.stream(pathEntriesArray).filter(Objects::nonNull).collect(Collectors.toList());
            logger.debug("pathEntries = {}", pathEntries);
            for (int i = 0; i < pathEntries.size(); ++i) {
                Map.Entry pathEntry = (Map.Entry)pathEntries.get(i);
                variables.put(pathEntry.getKey(), "{variable" + i + "}");
            }
        }
        if (pathEntries == null || pathEntries.isEmpty()) {
            return path;
        }
        try {
            URI uri = UriComponentsBuilder.fromPath((String)path).build(variables);
            return URLDecoder.decode(uri.toString(), StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return path;
        }
    }

    public static String reRenderUrl(String url) {
        PathContainer urlContainer = PathContainer.parsePath((String)url);
        PathPattern urlPattern = PATH_PATTERN_PARSER.parse(url);
        PathPattern.PathMatchInfo pathMatchInfo = urlPattern.matchAndExtract(urlContainer);
        if (pathMatchInfo == null) {
            return url;
        }
        Map urlVariables = pathMatchInfo.getUriVariables();
        HashMap variables = new HashMap(urlVariables.size());
        List urlEntries = null;
        if (!urlVariables.isEmpty()) {
            logger.debug("url.variables: {} ", (Object)urlVariables);
            Map.Entry[] pathEntriesArray = new Map.Entry[url.length()];
            for (Map.Entry entry : urlVariables.entrySet()) {
                int index = StringUtils.indexOf((CharSequence)url, (CharSequence)((CharSequence)entry.getValue()));
                logger.debug("url entry.value = {}, index = {}", entry.getValue(), (Object)index);
                pathEntriesArray[index] = entry;
            }
            urlEntries = Arrays.stream(pathEntriesArray).filter(Objects::nonNull).collect(Collectors.toList());
            logger.debug("urlEntries = {}", urlEntries);
            for (int i = 0; i < urlEntries.size(); ++i) {
                Map.Entry pathEntry = (Map.Entry)urlEntries.get(i);
                variables.put(pathEntry.getKey(), "{variable" + i + "}");
            }
        }
        if (urlEntries == null || urlEntries.isEmpty()) {
            return url;
        }
        try {
            URI uri = UriComponentsBuilder.fromHttpUrl((String)url).build(variables);
            return URLDecoder.decode(uri.toString(), StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return url;
        }
    }
}

