/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.ServiceApi;
import com.xforceplus.jpa.listener.OperatorListener;
import com.xforceplus.utils.ApiUtils;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;

public class ServiceApiListener
extends OperatorListener<ServiceApi> {
    @PrePersist
    public void prePersist(ServiceApi entity) {
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank((CharSequence)entity.getHash())) {
            this.setHash(entity);
        }
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(ServiceApi entity) {
        this.setHash(entity);
        super.beforeUpdate(entity);
    }

    private void setHash(ServiceApi entity) {
        if (StringUtils.isNotBlank((CharSequence)entity.getServiceApiUrl())) {
            String hash = ApiUtils.hash(entity.getServiceApiUrl(), entity.getRequestMethod().name(), entity.getRouteId());
            entity.setHash(hash);
        }
    }
}

