package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Resource;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 资源码自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class ResourceListener extends OperatorListener<Resource> {
    @PrePersist
    public void prePersist(Resource entity) {
        if (entity.getIsServicePackage() == null) {
            entity.setIsServicePackage(false);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(Resource entity) {
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(Resource entity) {
        entity.setApp(null);
        entity.setResourceApiRels(null);
    }
}