package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Route;
import com.xforceplus.utils.RouteUtils;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import java.util.Calendar;
import java.util.Date;

/**
 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 @author geewit
 @since  2019-10-29
 */
public class RouteListener {
    @PrePersist
    public void prePersist(Route route) {
        if(route.getCreateTime() == null) {
            Date now = Calendar.getInstance().getTime();
            route.setCreateTime(now);
        }
        if(route.getCreateUserId() == null) {
            IAuthorizedUser user = UserInfoHolder.get();
            if(user != null) {
                route.setCreateUserId(String.valueOf(user.getId()));
                route.setCreateUserName(user.getUsername());
            }
        }
        if(StringUtils.isNotBlank(route.getPath()) && StringUtils.isBlank(route.getPath())) {
            String hash = RouteUtils.hash(route.getPath());
            route.setHash(hash);
        }
    }

//    @PreUpdate
//    public void preUpdate(Route route) {
//        Integer createrId = listenedEntity.getUpdaterId();
//    }
}