package com.xforceplus.query;

import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.route.api.common.model.ServiceApiModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class ServiceApiQueryHelper {
    public static Specification<ServiceApi> querySpecification(ServiceApiModel.Request.Query query) {
        Specification<ServiceApi> specification = (Specification<ServiceApi>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            boolean joinTable = false;
            if ((query.getTenantId() != null && query.getTenantId() > 0) || (query.getResourceId() != null && query.getResourceId() > 0) || StringUtils.isNotBlank(query.getResourceCode())) {
                ListJoin<ServiceApi, ResourceApiRel> joinResourceApiRels = root.joinList("resourceApiRels", JoinType.LEFT);
                Join<ResourceApiRel, Resource> joinResource = joinResourceApiRels.join("resource", JoinType.LEFT);
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal(joinResource.get("status"), 1));
                }
                if ((query.getResourceId() != null && query.getResourceId() > 0) || StringUtils.isNotBlank(query.getResourceCode())) {
                    if (query.getResourceId() != null && query.getResourceId() > 0) {
                        predicates.add(builder.equal(joinResource.<Long>get("resourceId"), query.getResourceId()));
                    }
                    if (StringUtils.isNotBlank(query.getResourceCode())) {
                        predicates.add(builder.equal(joinResource.<String>get("resourceCode"), query.getResourceCode()));
                    }
                }
                joinTable = true;
            }
            if (query.getServiceApiId() != null && query.getServiceApiId() > 0) {
                predicates.add(builder.equal(root.<Long>get("serviceApiId"), query.getServiceApiId()));
            }
            if (StringUtils.isNotBlank(query.getServiceApiUrl())) {
                predicates.add(builder.equal(root.<String>get("serviceApiUrl"), query.getServiceApiUrl()));
            }
            if (StringUtils.isNotBlank(query.getServiceApiPath())) {
                predicates.add(builder.equal(root.<String>get("serviceApiPath"), query.getServiceApiPath()));
            }
            if (query.getAppId() != null && query.getAppId() > 0) {
                predicates.add(builder.equal(root.<Long>get("appId"), query.getAppId()));
            }
            if (query.getRouteId() != null && query.getRouteId() > 0) {
                predicates.add(builder.equal(root.<Long>get("routeId"), query.getRouteId()));
            }
            if (StringUtils.isNotBlank(query.getServiceApiName())) {
                predicates.add(builder.like(root.get("serviceApiName"), query.getServiceApiName() + "%"));
            }
            if (query.getRequestMethod() != null) {
                predicates.add(builder.equal(root.<RequestMethod>get("requestMethod"), query.getRequestMethod()));
            }
            if (query.getSkipCheck() != null) {
                predicates.add(builder.equal(root.<Integer>get("skipCheck"), query.getSkipCheck()));
            }
            if (query.getSkipAuth() != null) {
                predicates.add(builder.equal(root.<Integer>get("skipAuth"), query.getSkipAuth()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                } else {
                    criteriaQuery.groupBy(root.<Long>get("serviceApiId"));
                    return criteriaQuery.getGroupRestriction();
                }
            } else {
                return criteriaQuery.getRestriction();
            }
        };
        return specification;
    }

}
