package com.xforceplus.utils;

import com.google.common.hash.Hashing;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

/**
 * ServiceApi Path相关的工具类
 * @author geewit
 */
public class ApiUtils {
    private final static Logger logger = LoggerFactory.getLogger(ApiUtils.class);

    private final static String PATH_VARIABLE_NAME_PREFIX = "variable";

    public static String replacePathVariable(String path, PathPatternParser pathPatternParser) {
        PathPattern pathPattern = pathPatternParser.parse(path);
        PathContainer pathContainer = PathContainer.parsePath(path);
        PathPattern.PathMatchInfo pathMatchInfo = pathPattern.matchAndExtract(pathContainer);
        if(pathMatchInfo != null) {
            Map<String, String> pathVariables = pathMatchInfo.getUriVariables();
            if(!pathVariables.isEmpty()) {
                logger.debug("path.variables: {} ", pathVariables);
                Map.Entry<String, String>[] pathEntriesArray = new Map.Entry[path.length()];
                for (Map.Entry<String, String> entry : pathVariables.entrySet()) {
                    int index = StringUtils.indexOf(path, entry.getValue());
                    logger.debug("prePath entry.value = {}, index = {}", entry.getValue(), index);
                    pathEntriesArray[index] = entry;
                }
                List<String> pathVariableNames = Arrays.stream(pathEntriesArray).filter(Objects::nonNull).map(Map.Entry::getKey).collect(Collectors.toList());
                logger.debug("pathVariableNames = {}", pathVariableNames);
                Map<String, String> newPathVariables = new HashMap<>(pathVariableNames.size());
                if(!pathVariableNames.isEmpty()) {
                    for(int i = 0; i < pathVariableNames.size(); i++) {
                        newPathVariables.put(pathVariableNames.get(i), "{" + PATH_VARIABLE_NAME_PREFIX + (i + 1) + "}");
                    }
                    try {
                        String newPath = UriComponentsBuilder.fromPath(path).buildAndExpand(newPathVariables).getPath();
                        if(newPath == null) {
                            return path;
                        }
                        newPath = URLDecoder.decode(newPath, StandardCharsets.UTF_8.name());
                        return newPath;
                    } catch (Exception ignored) {
                        return path;
                    }
                }
            }
        }
        return path;
    }

    public static String hash(String path, String httpMethod, Long routeId) {
        String renderPath = RouteUtils.reRenderPath(path);
        logger.debug("renderPath = {}", path);
        renderPath = routeId + "@" + renderPath + "@" + httpMethod;
        String hash = Hashing.sha1().newHasher().putString(renderPath, StandardCharsets.UTF_8).hash().toString();
        return hash;
    }
}
