package com.xforceplus.dao;

import com.xforceplus.entity.Resource;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ResourceDao extends EntityGraphJpaRepository<Resource, Long>, EntityGraphJpaSpecificationExecutor<Resource> {
    @Override
    @Transactional
    @Modifying(clearAutomatically = true)
    @Query("delete from Resource r where r.resourceId = :resourceId")
    void deleteById(@Param("resourceId") Long id);

    @Transactional(readOnly = true)
    List<Resource> findByParentId(long parentId);

    @Transactional
    @Modifying(flushAutomatically = true)
    @Query("update Resource r set r.status = :status where r.resourceId = :id")
    int updateStatus(@Param("id") long id, @Param("status") int status);

    @Transactional(readOnly = true)
    @Query("select new org.apache.commons.lang3.tuple.MutablePair(r.resourceId, r.resourceName) from Resource r where r.resourceId in :resourceIds")
    List<Pair<Long, String>> findResourceNamePairsByResourceIds(@Param("resourceIds") Collection<Long> resourceIds);

    /**
     * 根据AppId和资源码记录查询列表
     *
     * @param appId        AppId
     * @param resourceCode ResourceCode
     * @return List<Resource>
     */
    @Transactional(readOnly = true)
    List<Resource> findByAppIdAndResourceCode(Long appId, String resourceCode);

    @Transactional(readOnly = true)
    @Query("select rel.resource from com.xforceplus.entity.ResourceApiRel rel where rel.serviceApiId = :serviceApiId")
    List<Resource> findByServiceApiId(long serviceApiId);
}
