package com.xforceplus.dao;

import com.xforceplus.entity.Route;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import io.geewit.data.jpa.essential.repository.EntityGraphPagingAndSortingRepository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author geewit
 */
public interface RouteDao extends EntityGraphPagingAndSortingRepository<Route, Long>, EntityGraphJpaSpecificationExecutor<Route>, CustomizedRouteDao {
    /**
     * 按Path查询路由
     * @param path Path路由
     * @return  Optional<Route>
     */
    @Transactional(readOnly = true)
    List<Route> findByPath(String path);

    /**
     * 按hash值查看是否已存在相同的route
     * @param hash
     * @return
     */
    @Transactional(readOnly = true)
    long countByHash(String hash);
}
