package com.xforceplus.dao.impl;

import com.xforceplus.route.api.common.model.ServiceApiModel.*;
import com.xforceplus.dao.CustomizedRouteDao;
import com.xforceplus.utils.ApiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.pattern.PathPatternParser;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.*;

/**
 * @author geewit
 */
@Service
public class CustomizedRouteDaoImpl implements CustomizedRouteDao {
    private final static Logger logger = LoggerFactory.getLogger(CustomizedRouteDaoImpl.class);

    private final PathPatternParser pathPatternParser = PathPatternParser.defaultInstance;

    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional(readOnly = true)
    public Map<Long, Set<Response.ServiceApiWithResource>> all() {
        String sql = "SELECT\n" +
                "api.service_api_id,\n" +
                "api.service_api_name,\n" +
                "api.service_api_url,\n" +
                "api.request_method,\n" +
                "api.route_id,\n" +
                "api.`skip_authentication`,\n" +
                "api.`skip_authorization`,\n" +
                "api.`timeout`,\n" +
                "r.resource_id,\n" +
                "r.resource_code,\n" +
                "r.resource_name\n" +
                "FROM\n" +
                "sys_service_api AS api\n" +
                "LEFT JOIN sys_resource_api_rel AS rel ON rel.service_api_id = api.service_api_id\n" +
                "LEFT JOIN sys_resource AS r ON rel.resource_id = r.resource_id\n" +
                "WHERE\n" +
                "api.`status` = 1 AND\n" +
                "api.route_id IN ((select route.route_id from bss_route route))";
        List<Object[]> list = entityManager.createNativeQuery(sql).getResultList();
        Map<Long, Set<Response.ServiceApiWithResource>> result = new HashMap<>();
        Map<Long, Response.ServiceApiWithResource> serviceApiMap = new HashMap<>();
        for(Object[] objects : list) {
            Long serviceApiId = null;
            if(objects[0] != null) {
                if(objects[0] instanceof Number) {
                    serviceApiId = ((Number)objects[0]).longValue();
                }
            }
            if(serviceApiId == null) {
                continue;
            }
            Response.ServiceApiWithResource item = serviceApiMap.get(serviceApiId);
            Long routeId = ((Number)objects[4]).longValue();
            if(item == null) {
                item = new Response.ServiceApiWithResource();
                String serviceApiName = (String)objects[1];
                String serviceApiUrl = (String)objects[2];
                serviceApiUrl = ApiUtils.replacePathVariable(serviceApiUrl, pathPatternParser);
                String requestMethod = (String)objects[3];
                boolean isSkipAuthentication = false;
                if(objects[5] != null) {
                    if(objects[5] instanceof Boolean) {
                        isSkipAuthentication = (Boolean)objects[5];
                    } else if(objects[5] instanceof Number) {
                        isSkipAuthentication = Objects.equals(((Number)objects[5]).byteValue(), Byte.valueOf("1"));
                    }
                }
                boolean isSkipAuthorization = false;
                if(objects[6] != null) {
                    if(objects[6] instanceof Boolean) {
                        isSkipAuthorization = (Boolean)objects[6];
                    } else if(objects[6] instanceof Number) {
                        isSkipAuthorization = Objects.equals(((Number)objects[6]).byteValue(), Byte.valueOf("1"));
                    }
                }
                item.setServiceApiId(serviceApiId);
                item.setServiceApiName(serviceApiName);
                item.setServiceApiUrl(serviceApiUrl);
                item.setRequestMethod(RequestMethod.valueOf(requestMethod));
                item.setRouteId(routeId);
                item.setSkipAuthentication(isSkipAuthentication);
                item.setSkipAuthorization(isSkipAuthorization);
                Integer timeout = null;
                if(objects[7] != null) {
                    if(objects[7] instanceof Number) {
                        timeout = ((Number)objects[7]).intValue();
                    }
                }
                item.setTimeout(timeout);
                serviceApiMap.put(serviceApiId, item);
            }
            Long resourceId = objects[8] != null ? ((Number)objects[8]).longValue() : null;
            if(resourceId != null) {
                Response.WithResource resource = new Response.WithResource();
                String resourceCode = (String)objects[9];
                String resourceName = (String)objects[10];
                resource.setResourceId(resourceId);
                resource.setResourceName(resourceName);
                resource.setResourceCode(resourceCode);
                item.addResource(resource);
            }
            Set<Response.ServiceApiWithResource> serviceApis = result.getOrDefault(routeId, new HashSet<>());
            serviceApis.add(item);
            result.put(routeId, serviceApis);
        }
        return result;
    }
}
