package com.xforceplus.jpa.listener;

import com.xforceplus.entity.RouteApply;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;

import javax.persistence.PrePersist;
import java.util.Calendar;
import java.util.Date;

/**
 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 @author lengmz
 @since  2019-10-29
 */
public class RouteApplyListener {
    @PrePersist
    public void prePersist(RouteApply routeApply) {
        if(routeApply.getCreateTime() == null) {
            Date now = Calendar.getInstance().getTime();
            routeApply.setCreateTime(now);
        }
        if(routeApply.getCreateUserId() == null) {
            IAuthorizedUser user = UserInfoHolder.get();
            if(user != null) {
                routeApply.setCreateUserId(String.valueOf(user.getId()));
                routeApply.setCreateUserName(user.getUsername());
            }
        }
    }

//    @PreUpdate
//    public void preUpdate(Route route) {
//        Integer createrId = listenedEntity.getUpdaterId();
//    }
}