package com.xforceplus.jpa.listener;


import com.xforceplus.entity.ServiceApi;
import com.xforceplus.utils.ApiUtils;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class ServiceApiListener extends OperatorListener<ServiceApi> {
    @PrePersist
    public void prePersist(ServiceApi entity) {
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank(entity.getHash())) {
            this.setHash(entity);
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(ServiceApi entity) {
        this.setHash(entity);
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void setHash(ServiceApi entity) {
        if (StringUtils.isNotBlank(entity.getServiceApiUrl())) {
            String hash = ApiUtils.hash(entity.getServiceApiUrl(), entity.getRequestMethod().name(), entity.getRouteId());
            entity.setHash(hash);
        }
    }

    private void cleanRelatedEntities(ServiceApi entity) {
        entity.setApp(null);
        entity.setResourceApiRels(null);
    }
}