package com.xforceplus.query;

import com.xforceplus.route.api.common.model.RouteModel;
import com.xforceplus.entity.Route;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.*;
import java.util.*;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public class RouteQueryHelper {
    private final static Logger logger = LoggerFactory.getLogger(RouteQueryHelper.class);

    public static Specification<Route> querySpecification(RouteModel.Request.Query query) {
        Specification<Route> specification = (Specification<Route>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            Set<Long> filterRouteIds = new HashSet<>();
            if (query.getRouteId() != null && query.getRouteId() > 0) {
                filterRouteIds.add(query.getRouteId());
            }
            if (StringUtils.isNotBlank(query.getRouteIds())) {
                Arrays.stream(StringUtils.split(query.getRouteIds(), ",")).forEach(id -> {
                    try {
                        Long parseLong = Long.parseLong(id);
                        filterRouteIds.add(parseLong);
                    } catch (NumberFormatException e) {
                        String message = e.getMessage() + ", id: " + id;
                        logger.warn(message);
                    }
                });
            }
            if (!filterRouteIds.isEmpty()) {
                Predicate idPredicate;
                if (filterRouteIds.size() == 1) {
                    idPredicate = builder.equal(root.<Long>get("routeId"), filterRouteIds.stream().findFirst().get());
                } else {
                    idPredicate = root.<Long>get("routeId").in(filterRouteIds);
                }
                predicates.add(idPredicate);
            } else {
                if (StringUtils.isNotBlank(query.getRouteName())) {
                    predicates.add(builder.like(root.get("routeName"), "%" + query.getRouteName() + "%"));
                }
                if (StringUtils.isNotBlank(query.getPath())) {
                    predicates.add(builder.like(root.get("path"), "%" + query.getPath() + "%"));
                }
                if (query.getAppId() != null && query.getAppId() > 0) {
                    predicates.add(builder.equal(root.<Boolean>get("appId"), query.getAppId()));
                }
                if (StringUtils.isNotBlank(query.getUrl())) {
                    predicates.add(builder.like(root.get("url"), "%" + query.getUrl() + "%"));
                }
                if (query.getIsStatic() != null) {
                    predicates.add(builder.equal(root.<Boolean>get("isStatic"), query.getIsStatic()));
                }
                if (query.getIsExactMatch() != null) {
                    predicates.add(builder.equal(root.<Boolean>get("isExactMatch"), query.getIsExactMatch()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
                }
                if (query.getBillable() != null) {
                    predicates.add(builder.equal(root.<Boolean>get("billable"), query.getBillable()));
                }
                if (query.getSkipAuthentication() != null) {
                    predicates.add(builder.equal(root.<Boolean>get("skipAuthentication"), query.getSkipAuthentication()));
                }
                if (query.getSkipAuthorization() != null) {
                    predicates.add(builder.equal(root.<Boolean>get("skipAuthorization"), query.getSkipAuthorization()));
                }
                if (StringUtils.isNotBlank(query.getGroupType())) {
                    predicates.add(builder.equal(root.<String>get("groupType"), query.getGroupType()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
