/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.entity.Resource;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface ResourceDao
extends EntityGraphJpaRepository<Resource, Long>,
EntityGraphJpaSpecificationExecutor<Resource> {
    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="delete from Resource r where r.resourceId = :resourceId")
    public void deleteById(@Param(value="resourceId") Long var1);

    @Transactional(readOnly=true)
    public List<Resource> findByParentId(long var1);

    @Transactional
    @Modifying(flushAutomatically=true)
    @Query(value="update Resource r set r.status = :status where r.resourceId = :id")
    public int updateStatus(@Param(value="id") long var1, @Param(value="status") int var3);

    @Transactional(readOnly=true)
    @Query(value="select new org.apache.commons.lang3.tuple.MutablePair(r.resourceId, r.resourceName) from Resource r where r.resourceId in :resourceIds")
    public List<Pair<Long, String>> findResourceNamePairsByResourceIds(@Param(value="resourceIds") Collection<Long> var1);

    @Transactional(readOnly=true)
    public List<Resource> findByAppIdAndResourceCode(Long var1, String var2);

    @Transactional(readOnly=true)
    @Query(value="select rel.resource from com.xforceplus.entity.ResourceApiRel rel where rel.serviceApiId = :serviceApiId")
    public List<Resource> findByServiceApiId(long var1);
}

