/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.dao.CustomizedRouteDao;
import com.xforceplus.route.api.common.model.ServiceApiModel;
import com.xforceplus.utils.ApiUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.pattern.PathPatternParser;

@Service
public class CustomizedRouteDaoImpl
implements CustomizedRouteDao {
    private static final Logger logger = LoggerFactory.getLogger(CustomizedRouteDaoImpl.class);
    private final PathPatternParser pathPatternParser = PathPatternParser.defaultInstance;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional(readOnly=true)
    public Map<Long, Set<ServiceApiModel.Response.ServiceApiWithResource>> all() {
        String sql = "SELECT\napi.service_api_id,\napi.service_api_name,\napi.service_api_url,\napi.request_method,\napi.route_id,\napi.`skip_authentication`,\napi.`skip_authorization`,\napi.`timeout`,\nr.resource_id,\nr.resource_code,\nr.resource_name\nFROM\nsys_service_api AS api\nLEFT JOIN sys_resource_api_rel AS rel ON rel.service_api_id = api.service_api_id\nLEFT JOIN sys_resource AS r ON rel.resource_id = r.resource_id\nWHERE\napi.`status` = 1 AND\napi.route_id IN ((select route.route_id from bss_route route))";
        List list = this.entityManager.createNativeQuery(sql).getResultList();
        HashMap<Long, Set<ServiceApiModel.Response.ServiceApiWithResource>> result = new HashMap<Long, Set<ServiceApiModel.Response.ServiceApiWithResource>>();
        HashMap<Long, ServiceApiModel.Response.ServiceApiWithResource> serviceApiMap = new HashMap<Long, ServiceApiModel.Response.ServiceApiWithResource>();
        for (Object[] objects : list) {
            Long resourceId;
            Long serviceApiId = null;
            if (objects[0] != null && objects[0] instanceof Number) {
                serviceApiId = ((Number)objects[0]).longValue();
            }
            if (serviceApiId == null) continue;
            ServiceApiModel.Response.ServiceApiWithResource item = (ServiceApiModel.Response.ServiceApiWithResource)serviceApiMap.get(serviceApiId);
            Long routeId = ((Number)objects[4]).longValue();
            if (item == null) {
                item = new ServiceApiModel.Response.ServiceApiWithResource();
                String serviceApiName = (String)objects[1];
                String serviceApiUrl = (String)objects[2];
                serviceApiUrl = ApiUtils.replacePathVariable(serviceApiUrl, this.pathPatternParser);
                String requestMethod = (String)objects[3];
                boolean isSkipAuthentication = false;
                if (objects[5] != null) {
                    if (objects[5] instanceof Boolean) {
                        isSkipAuthentication = (Boolean)objects[5];
                    } else if (objects[5] instanceof Number) {
                        isSkipAuthentication = Objects.equals(((Number)objects[5]).byteValue(), Byte.valueOf("1"));
                    }
                }
                boolean isSkipAuthorization = false;
                if (objects[6] != null) {
                    if (objects[6] instanceof Boolean) {
                        isSkipAuthorization = (Boolean)objects[6];
                    } else if (objects[6] instanceof Number) {
                        isSkipAuthorization = Objects.equals(((Number)objects[6]).byteValue(), Byte.valueOf("1"));
                    }
                }
                item.setServiceApiId(serviceApiId);
                item.setServiceApiName(serviceApiName);
                item.setServiceApiUrl(serviceApiUrl);
                item.setRequestMethod(RequestMethod.valueOf((String)requestMethod));
                item.setRouteId(routeId);
                item.setSkipAuthentication(Boolean.valueOf(isSkipAuthentication));
                item.setSkipAuthorization(Boolean.valueOf(isSkipAuthorization));
                Integer timeout = null;
                if (objects[7] != null && objects[7] instanceof Number) {
                    timeout = ((Number)objects[7]).intValue();
                }
                item.setTimeout(timeout);
                serviceApiMap.put(serviceApiId, item);
            }
            Long l = resourceId = objects[8] != null ? Long.valueOf(((Number)objects[8]).longValue()) : null;
            if (resourceId != null) {
                ServiceApiModel.Response.WithResource resource = new ServiceApiModel.Response.WithResource();
                String resourceCode = (String)objects[9];
                String resourceName = (String)objects[10];
                resource.setResourceId(resourceId);
                resource.setResourceName(resourceName);
                resource.setResourceCode(resourceCode);
                item.addResource(resource);
            }
            Set serviceApis = result.getOrDefault(routeId, new HashSet());
            serviceApis.add(item);
            result.put(routeId, serviceApis);
        }
        return result;
    }
}

