/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.entity.ServiceApi;
import com.xforceplus.route.api.common.model.ServiceApiModel;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class ServiceApiQueryHelper {
    public static Specification<ServiceApi> querySpecification(ServiceApiModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            boolean joinTable = false;
            if (query.getTenantId() != null && query.getTenantId() > 0L || query.getResourceId() != null && query.getResourceId() > 0L || StringUtils.isNotBlank((CharSequence)query.getResourceCode())) {
                ListJoin joinResourceApiRels = root.joinList("resourceApiRels", JoinType.LEFT);
                Join joinResource = joinResourceApiRels.join("resource", JoinType.LEFT);
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal((Expression)joinResource.get("status"), (Object)1));
                }
                if (query.getResourceId() != null && query.getResourceId() > 0L || StringUtils.isNotBlank((CharSequence)query.getResourceCode())) {
                    if (query.getResourceId() != null && query.getResourceId() > 0L) {
                        predicates.add(builder.equal((Expression)joinResource.get("resourceId"), (Object)query.getResourceId()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getResourceCode())) {
                        predicates.add(builder.equal((Expression)joinResource.get("resourceCode"), (Object)query.getResourceCode()));
                    }
                }
                joinTable = true;
            }
            if (query.getServiceApiId() != null && query.getServiceApiId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("serviceApiId"), (Object)query.getServiceApiId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServiceApiUrl())) {
                predicates.add(builder.equal((Expression)root.get("serviceApiUrl"), (Object)query.getServiceApiUrl()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServiceApiPath())) {
                predicates.add(builder.equal((Expression)root.get("serviceApiPath"), (Object)query.getServiceApiPath()));
            }
            if (query.getAppId() != null && query.getAppId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
            }
            if (query.getRouteId() != null && query.getRouteId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("routeId"), (Object)query.getRouteId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServiceApiName())) {
                predicates.add(builder.like((Expression)root.get("serviceApiName"), query.getServiceApiName() + "%"));
            }
            if (query.getRequestMethod() != null) {
                predicates.add(builder.equal((Expression)root.get("requestMethod"), (Object)query.getRequestMethod()));
            }
            if (query.getSkipCheck() != null) {
                predicates.add(builder.equal((Expression)root.get("skipCheck"), (Object)query.getSkipCheck()));
            }
            if (query.getSkipAuth() != null) {
                predicates.add(builder.equal((Expression)root.get("skipAuth"), (Object)query.getSkipAuth()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get("serviceApiId")});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

