/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.entity.Route;
import com.xforceplus.entity.Route_;
import com.xforceplus.route.api.common.model.RouteModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;

public class RouteQueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(RouteQueryHelper.class);

    public static Specification<Route> querySpecification(RouteModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            HashSet<Long> filterRouteIds = new HashSet<Long>();
            if (query.getRouteId() != null && query.getRouteId() > 0L) {
                filterRouteIds.add(query.getRouteId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getRouteIds())) {
                Arrays.stream(StringUtils.split((String)query.getRouteIds(), (String)",")).forEach(id -> {
                    try {
                        Long parseLong = Long.parseLong(id);
                        filterRouteIds.add(parseLong);
                    }
                    catch (NumberFormatException e) {
                        String message = e.getMessage() + ", id: " + id;
                        logger.warn(message);
                    }
                });
            }
            if (!filterRouteIds.isEmpty()) {
                Predicate idPredicate = filterRouteIds.size() == 1 ? builder.equal((Expression)root.get(Route_.routeId), filterRouteIds.stream().findFirst().get()) : root.get(Route_.routeId).in(filterRouteIds);
                predicates.add(idPredicate);
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getRouteName())) {
                    predicates.add(builder.like((Expression)root.get(Route_.routeName), "%" + query.getRouteName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getContact())) {
                    predicates.add(builder.like((Expression)root.get(Route_.contact), "%" + query.getContact() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getContactTeam())) {
                    predicates.add(builder.like((Expression)root.get(Route_.contactTeam), "%" + query.getContactTeam() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getPath())) {
                    predicates.add(builder.like((Expression)root.get(Route_.path), "%" + query.getPath() + "%"));
                }
                if (query.getAppId() != null && query.getAppId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get(Route_.appId), (Object)query.getAppId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getUrl())) {
                    predicates.add(builder.like((Expression)root.get(Route_.url), "%" + query.getUrl() + "%"));
                }
                if (query.getIsStatic() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.isStatic), (Object)query.getIsStatic()));
                }
                if (query.getIsExactMatch() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.isExactMatch), (Object)query.getIsExactMatch()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.status), (Object)query.getStatus()));
                }
                if (query.getBillable() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.billable), (Object)query.getBillable()));
                }
                if (query.getSkipAuthentication() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.skipAuthentication), (Object)query.getSkipAuthentication()));
                }
                if (query.getSkipAuthorization() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.skipAuthorization), (Object)query.getSkipAuthorization()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getGroupType())) {
                    predicates.add(builder.equal((Expression)root.get(Route_.groupType), (Object)query.getGroupType()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

