package com.xforceplus.dao;

import com.xforceplus.entity.App;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface AppDao extends EntityGraphJpaRepository<App, Long>, EntityGraphJpaSpecificationExecutor<App> {
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Modifying(flushAutomatically = true, clearAutomatically = true)
    @Query("delete from App a where a.appId = :appId")
    void deleteById(@Param("appId") Long id);
}
