package com.xforceplus.dao;

import com.xforceplus.entity.Route;
import io.geewit.data.jpa.envers.repository.EnversRevisionRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import io.geewit.data.jpa.essential.repository.EntityGraphPagingAndSortingRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * @author geewit
 */
public interface RouteDao extends EntityGraphJpaRepository<Route, Long>,
        EntityGraphJpaSpecificationExecutor<Route>,
        EnversRevisionRepository<Route, Long, String>, CustomizedRouteDao {
    /**
     * 按Path查询路由
     * @param path Path路由
     * @return  Optional<Route>
     */
    @Transactional(readOnly = true)
    List<Route> findByPath(String path);

    @Transactional(readOnly = true)
    @Query("select r.path from Route r where r.routeId in :routeIds")
    Set<String> findPathByRouteIds(@Param("routeIds") Collection<Long> routeIds);

    /**
     * 按hash值查看是否已存在相同的route
     * @param hash
     * @return
     */
    @Transactional(readOnly = true)
    long countByHash(String hash);
}
