package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.app.AppDto;
import com.xforceplus.jpa.listener.AppListener;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@EntityListeners({AppListener.class})
@Entity
@Table(name = "bss_app")
public class App extends AppDto implements Serializable {

    public App() {
        super();
    }

    public App(Long appId, String appName) {
        super(appId, appName);
    }

    @Override
    @Id
    @Column(name = "app_id")
    public Long getAppId() {
        return appId;
    }

    @Override
    @Basic
    @Column(name = "app_name")
    public String getAppName() {
        return appName;
    }

    @Override
    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "resource_prefix")
    public String getResourcePrefix() {
        return resourcePrefix;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

}
