package com.xforceplus.entity;

import com.xforceplus.action.trail.core.annotation.Trail;
import com.xforceplus.jpa.listener.GlobalRevisionListener;
import io.geewit.data.jpa.envers.EnversRevisionEntity;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.envers.RevisionEntity;

import javax.persistence.*;
import java.util.Date;

/**
 * 数据库变动日志
 *
 * @author geewit
 * @since 2020-11-09
 */
@Setter
@Entity
@DynamicInsert
@DynamicUpdate
@RevisionEntity(GlobalRevisionListener.class)
@Table(name = "global_revisions")
@Trail(enable = false)
public class GlobalRevisionEntity extends EnversRevisionEntity<Long> {

    private Long operatorId;

    private String operatorName;

    @Override
    @SuppressWarnings({"unused"})
    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @Column(name = "id", updatable = false)
    public Long getId() {
        return super.id;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "revision_time")
    public Date getRevisionTime() {
        return super.revisionTime;
    }

    @Override
    @Basic
    @Column(name = "operator_id")
    public Long getOperatorId() {
        return this.operatorId;
    }

    @Override
    @Basic
    @Column(name = "operator_name")
    public String getOperatorName() {
        return this.operatorName;
    }
}
