package com.xforceplus.entity;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.route.RouteApplyDto;
import com.xforceplus.jpa.listener.RouteApplyListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_route_apply")
@EntityListeners({RouteApplyListener.class})
public class RouteApply extends RouteApplyDto implements Serializable {

    @Override
    @Id
    @Column(name = "route_apply_id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getRouteApplyId() {
        return routeApplyId;
    }

    @Override
    @Basic
    @Column(name = "app_id")
    public Integer getAppId() {
        return appId;
    }

    @Override
    @Basic
    @Column(name = "route_name")
    public String getRouteName() {
        return routeName;
    }

    @Override
    @Basic
    @Column(name = "path")
    public String getPath() {
        return path;
    }

    @Override
    @Basic
    @Column(name = "url")
    public String getUrl() {
        return url;
    }

    @Override
    @Basic
    @Column(name = "is_static")
    public Boolean getIsStatic() {
        return isStatic;
    }

    @Override
    @Basic
    @Column(name = "is_exact_match")
    public Boolean getIsExactMatch() {
        return isExactMatch;
    }

    @Override
    @Basic
    @Column(name = "operator")
    public Boolean getIsOperator() {
        return isOperator;
    }

    @Override
    @Basic
    @Column(name = "create_user_id")
    public String getCreateUserId() {
        return createUserId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name")
    public String getCreateUserName() {
        return createUserName;
    }

    @Override
    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "group_type")
    public String getGroupType() {
        return groupType;
    }

    @Override
    @Basic
    @Column(name = "billable")
    public Boolean getBillable() {
        return billable;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "skip_authentication")
    public Boolean getSkipAuthentication() {
        return skipAuthentication;
    }

    @Override
    @Basic
    @Column(name = "skip_authorization")
    public Boolean getSkipAuthorization() {
        return skipAuthorization;
    }

    @Override
    @Basic
    @Column(name = "hash")
    public String getHash() {
        return hash;
    }

    @Override
    @Basic
    @Column(name = "timeout")
    public Integer getTimeout() {
        return timeout;
    }

    @Override
    @Basic
    @Column(name = "enable_autoscan")
    public Boolean getEnableAutoscan() {
        return enableAutoscan;
    }
}
