package com.xforceplus.jpa.listener;


import com.xforceplus.entity.ResourceApiRel;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 资源码自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class ResourceApiRelListener {
    @PrePersist
    public void prePersist(ResourceApiRel entity) {
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(ResourceApiRel entity) {
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(ResourceApiRel entity) {
        entity.setResource(null);
        entity.setServiceApi(null);
    }
}