package com.xforceplus.query;

import com.xforceplus.entity.Route_;
import com.xforceplus.route.api.common.model.RouteModel;
import com.xforceplus.entity.Route;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.*;
import java.util.*;

/**
 * @author geewit
 */
@SuppressWarnings("all")
@Slf4j
public class RouteQueryHelper {

    public static Specification<Route> querySpecification(RouteModel.Request.Query query) {
        Specification<Route> specification = (Specification<Route>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            Set<Long> filterRouteIds = new HashSet<>();
            if (query.getRouteId() != null && query.getRouteId() > 0) {
                filterRouteIds.add(query.getRouteId());
            }
            if (StringUtils.isNotBlank(query.getRouteIds())) {
                Arrays.stream(StringUtils.split(query.getRouteIds(), ",")).forEach(id -> {
                    try {
                        Long parseLong = Long.parseLong(id);
                        filterRouteIds.add(parseLong);
                    } catch (NumberFormatException e) {
                        String message = e.getMessage() + ", id: " + id;
                        log.warn(message);
                    }
                });
            }
            if (!filterRouteIds.isEmpty()) {
                Predicate idPredicate;
                if (filterRouteIds.size() == 1) {
                    idPredicate = builder.equal(root.get(Route_.routeId), filterRouteIds.stream().findFirst().get());
                } else {
                    idPredicate = root.get(Route_.routeId).in(filterRouteIds);
                }
                predicates.add(idPredicate);
            } else {
                if (StringUtils.isNotBlank(query.getRouteName())) {
                    predicates.add(builder.like(root.get(Route_.routeName), StringUtils.wrapIfMissing(query.getRouteName(), "%")));
                }
                if (StringUtils.isNotBlank(query.getContact())) {
                    predicates.add(builder.like(root.get(Route_.contact), StringUtils.wrapIfMissing(query.getContact(), "%")));
                }
                if (StringUtils.isNotBlank(query.getContactTeam())) {
                    predicates.add(builder.like(root.get(Route_.contactTeam), StringUtils.wrapIfMissing(query.getContactTeam(), "%")));
                }
                if (StringUtils.isNotBlank(query.getPath())) {
                    predicates.add(builder.like(root.get(Route_.path), StringUtils.wrapIfMissing(query.getPath(), "%")));
                }
                if (query.getAppId() != null && query.getAppId() > 0) {
                    predicates.add(builder.equal(root.get(Route_.appId), query.getAppId()));
                }
                if (StringUtils.isNotBlank(query.getUrl())) {
                    predicates.add(builder.like(root.get(Route_.url), StringUtils.wrapIfMissing(query.getUrl(), "%")));
                }
                if (query.getIsStatic() != null) {
                    predicates.add(builder.equal(root.get(Route_.isStatic), query.getIsStatic()));
                }
                if (query.getIsExactMatch() != null) {
                    predicates.add(builder.equal(root.get(Route_.isExactMatch), query.getIsExactMatch()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal(root.get(Route_.status), query.getStatus()));
                }
                if (query.getBillable() != null) {
                    predicates.add(builder.equal(root.get(Route_.billable), query.getBillable()));
                }
                if (query.getSkipAuthentication() != null) {
                    predicates.add(builder.equal(root.get(Route_.skipAuthentication), query.getSkipAuthentication()));
                }
                if (query.getSkipAuthorization() != null) {
                    predicates.add(builder.equal(root.get(Route_.skipAuthorization), query.getSkipAuthorization()));
                }
                if(query.getForceAuthorize() != null){
                    predicates.add(builder.equal(root.get(Route_.forceAuthorize),query.getForceAuthorize()));
                }
                if (StringUtils.isNotBlank(query.getGroupType())) {
                    predicates.add(builder.equal(root.get(Route_.groupType), query.getGroupType()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
