package com.xforceplus.query;

import com.xforceplus.entity.*;
import com.xforceplus.route.api.common.model.ServiceApiModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class ServiceApiQueryHelper {
    public static Specification<ServiceApi> querySpecification(ServiceApiModel.Request.Query query) {
        Specification<ServiceApi> specification = (Specification<ServiceApi>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            boolean joinTable = false;
            if ((query.getStatus() != null && query.getStatus() == 1)
                    || (query.getResourceId() != null && query.getResourceId() > 0)
                    || StringUtils.isNotBlank(query.getResourceCode())) {
                ListJoin<ServiceApi, ResourceApiRel> joinResourceApiRels = root.join(ServiceApi_.resourceApiRels, JoinType.LEFT);
                if (query.getResourceId() != null && query.getResourceId() > 0) {
                    predicates.add(builder.equal(joinResourceApiRels.get(ResourceApiRel_.resourceId), query.getResourceId()));
                }
                if (query.getStatus() != null && query.getStatus() == 1 || StringUtils.isNotBlank(query.getResourceCode())) {
                    Join<ResourceApiRel, Resource> joinResource = joinResourceApiRels.join(ResourceApiRel_.resource, JoinType.LEFT);
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal(joinResource.get(Resource_.status), 1));
                    }
                    if (StringUtils.isNotBlank(query.getResourceCode())) {
                        predicates.add(builder.equal(joinResource.get(Resource_.resourceCode), query.getResourceCode()));
                    }
                }
                joinTable = true;
            }
            if (query.getServiceApiId() != null && query.getServiceApiId() > 0) {
                predicates.add(builder.equal(root.get(ServiceApi_.serviceApiId), query.getServiceApiId()));
            }
            if (StringUtils.isNotBlank(query.getServiceApiUrl())) {
                predicates.add(builder.equal(root.get(ServiceApi_.serviceApiUrl), query.getServiceApiUrl()));
            }
            if (StringUtils.isNotBlank(query.getServiceApiPath())) {
                predicates.add(builder.equal(root.get(ServiceApi_.serviceApiPath), query.getServiceApiPath()));
            }
            if (query.getAppId() != null && query.getAppId() > 0) {
                predicates.add(builder.equal(root.get(ServiceApi_.appId), query.getAppId()));
            }
            if (query.getRouteId() != null && query.getRouteId() > 0) {
                predicates.add(builder.equal(root.get(ServiceApi_.routeId), query.getRouteId()));
            }
            if (StringUtils.isNotBlank(query.getServiceApiName())) {
                predicates.add(builder.like(root.get(ServiceApi_.serviceApiName), StringUtils.appendIfMissing(query.getServiceApiName(), "%")));
            }
            if (query.getRequestMethod() != null) {
                predicates.add(builder.equal(root.get(ServiceApi_.requestMethod), query.getRequestMethod()));
            }
            if (query.getSkipAuthentication() != null) {
                predicates.add(builder.equal(root.get(ServiceApi_.skipAuthentication), query.getSkipAuthentication()));
            }
            if (query.getSkipAuthorization() != null) {
                predicates.add(builder.equal(root.get(ServiceApi_.skipAuthorization), query.getSkipAuthorization()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.get(ServiceApi_.status), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                } else {
                    criteriaQuery.groupBy(root.get(ServiceApi_.serviceApiId));
                    return criteriaQuery.getGroupRestriction();
                }
            } else {
                return criteriaQuery.getRestriction();
            }
        };
        return specification;
    }

}
