/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.entity.ResourceApiRel_;
import com.xforceplus.entity.Resource_;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.entity.ServiceApi_;
import com.xforceplus.route.api.common.model.ServiceApiModel;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class ServiceApiQueryHelper {
    public static Specification<ServiceApi> querySpecification(ServiceApiModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            boolean joinTable = false;
            if (query.getStatus() != null && query.getStatus() == 1 || query.getResourceId() != null && query.getResourceId() > 0L || StringUtils.isNotBlank((CharSequence)query.getResourceCode())) {
                ListJoin joinResourceApiRels = root.join(ServiceApi_.resourceApiRels, JoinType.LEFT);
                if (query.getResourceId() != null && query.getResourceId() > 0L) {
                    predicates.add(builder.equal((Expression)joinResourceApiRels.get(ResourceApiRel_.resourceId), (Object)query.getResourceId()));
                }
                if (query.getStatus() != null && query.getStatus() == 1 || StringUtils.isNotBlank((CharSequence)query.getResourceCode())) {
                    Join joinResource = joinResourceApiRels.join(ResourceApiRel_.resource, JoinType.LEFT);
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinResource.get(Resource_.status), (Object)1));
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getResourceCode())) {
                        predicates.add(builder.equal((Expression)joinResource.get(Resource_.resourceCode), (Object)query.getResourceCode()));
                    }
                }
                joinTable = true;
            }
            if (query.getServiceApiId() != null && query.getServiceApiId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.serviceApiId), (Object)query.getServiceApiId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServiceApiUrl())) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.serviceApiUrl), (Object)query.getServiceApiUrl()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServiceApiPath())) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.serviceApiPath), (Object)query.getServiceApiPath()));
            }
            if (query.getAppId() != null && query.getAppId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.appId), (Object)query.getAppId()));
            }
            if (query.getRouteId() != null && query.getRouteId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.routeId), (Object)query.getRouteId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServiceApiName())) {
                predicates.add(builder.like((Expression)root.get(ServiceApi_.serviceApiName), StringUtils.appendIfMissing((String)query.getServiceApiName(), (CharSequence)"%", (CharSequence[])new CharSequence[0])));
            }
            if (query.getRequestMethod() != null) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.requestMethod), (Object)query.getRequestMethod()));
            }
            if (query.getSkipAuthentication() != null) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.skipAuthentication), (Object)query.getSkipAuthentication()));
            }
            if (query.getSkipAuthorization() != null) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.skipAuthorization), (Object)query.getSkipAuthorization()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get(ServiceApi_.status), (Object)query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get(ServiceApi_.serviceApiId)});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

