/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Route;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.utils.RouteUtils;
import java.util.Objects;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.springframework.data.history.RevisionMetadata;

public class RouteListener {
    @PrePersist
    public void prePersist(Route entity) {
        IAuthorizedUser user;
        if (entity.getCreateUserId() == null && (user = UserInfoHolder.get()) != null) {
            entity.setCreateUserId(String.valueOf(user.getId()));
            entity.setCreateUserName(user.getUsername());
        }
        this.setHash(RevisionMetadata.RevisionType.INSERT, entity);
    }

    @PreUpdate
    public void preUpdate(Route entity) {
        this.setHash(RevisionMetadata.RevisionType.UPDATE, entity);
    }

    private void setHash(RevisionMetadata.RevisionType revisionType, Route entity) {
        boolean newPath = false;
        if (RevisionMetadata.RevisionType.INSERT.equals((Object)revisionType)) {
            newPath = true;
        } else if (entity instanceof ManagedEntity) {
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                String prePath = (String)entityEntry.getLoadedValue("path");
                newPath = !Objects.equals(prePath, entity.getPath());
            } else {
                boolean bl = newPath = entity.getPath() != null;
            }
        }
        if (newPath) {
            String hash = RouteUtils.hash(entity.getPath());
            entity.setHash(hash);
        }
    }
}

