/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.entity.Route;
import com.xforceplus.entity.Route_;
import com.xforceplus.route.api.common.model.RouteModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;

public class RouteQueryHelper {
    private static final Logger log = LoggerFactory.getLogger(RouteQueryHelper.class);

    public static Specification<Route> querySpecification(RouteModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            HashSet<Long> filterRouteIds = new HashSet<Long>();
            if (query.getRouteId() != null && query.getRouteId() > 0L) {
                filterRouteIds.add(query.getRouteId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getRouteIds())) {
                Arrays.stream(StringUtils.split((String)query.getRouteIds(), (String)",")).forEach(id -> {
                    try {
                        Long parseLong = Long.parseLong(id);
                        filterRouteIds.add(parseLong);
                    }
                    catch (NumberFormatException e) {
                        String message = e.getMessage() + ", id: " + id;
                        log.warn(message);
                    }
                });
            }
            if (query.getRouteIdsSet() != null && !query.getRouteIdsSet().isEmpty()) {
                filterRouteIds.addAll(query.getRouteIdsSet());
            }
            if (!filterRouteIds.isEmpty()) {
                Predicate idPredicate = filterRouteIds.size() == 1 ? builder.equal((Expression)root.get(Route_.routeId), filterRouteIds.stream().findFirst().get()) : root.get(Route_.routeId).in(filterRouteIds);
                predicates.add(idPredicate);
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getRouteName())) {
                    predicates.add(builder.like((Expression)root.get(Route_.routeName), StringUtils.wrapIfMissing((String)query.getRouteName(), (String)"%")));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getContact())) {
                    predicates.add(builder.like((Expression)root.get(Route_.contact), StringUtils.wrapIfMissing((String)query.getContact(), (String)"%")));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getContactTeam())) {
                    predicates.add(builder.like((Expression)root.get(Route_.contactTeam), StringUtils.wrapIfMissing((String)query.getContactTeam(), (String)"%")));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getPath())) {
                    predicates.add(builder.like((Expression)root.get(Route_.path), StringUtils.wrapIfMissing((String)query.getPath(), (String)"%")));
                }
                if (query.getAppId() != null && query.getAppId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get(Route_.appId), (Object)query.getAppId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getUrl())) {
                    predicates.add(builder.like((Expression)root.get(Route_.url), StringUtils.wrapIfMissing((String)query.getUrl(), (String)"%")));
                }
                if (query.getIsStatic() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.isStatic), (Object)query.getIsStatic()));
                }
                if (query.getIsExactMatch() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.isExactMatch), (Object)query.getIsExactMatch()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.status), (Object)query.getStatus()));
                }
                if (query.getBillable() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.billable), (Object)query.getBillable()));
                }
                if (query.getSkipAuthentication() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.skipAuthentication), (Object)query.getSkipAuthentication()));
                }
                if (query.getSkipAuthorization() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.skipAuthorization), (Object)query.getSkipAuthorization()));
                }
                if (query.getForceAuthorize() != null) {
                    predicates.add(builder.equal((Expression)root.get(Route_.forceAuthorize), (Object)query.getForceAuthorize()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getGroupType())) {
                    predicates.add(builder.equal((Expression)root.get(Route_.groupType), (Object)query.getGroupType()));
                }
            }
            Set noneIdsQuery = null;
            if (query.getNoneId() != null && query.getNoneId() > 0L) {
                noneIdsQuery = Stream.of(query.getNoneId()).collect(Collectors.toSet());
            }
            if (query.getNoneIds() != null && !query.getNoneIds().isEmpty()) {
                if (noneIdsQuery == null) {
                    noneIdsQuery = new HashSet(query.getNoneIds());
                } else {
                    noneIdsQuery.addAll(query.getNoneIds());
                }
            }
            if (noneIdsQuery != null && !(noneIdsQuery = noneIdsQuery.stream().filter(id -> id != null && id > 0L).collect(Collectors.toSet())).isEmpty()) {
                if (noneIdsQuery.size() == 1) {
                    predicates.add(builder.notEqual((Expression)root.get(Route_.routeId), noneIdsQuery.stream().findFirst().get()));
                } else {
                    predicates.add(builder.not((Expression)root.get(Route_.routeId).in(noneIdsQuery)));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

