package com.xforceplus.dao;

import com.xforceplus.entity.ResourceApiRel;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ResourceApiRelDao extends EntityGraphJpaRepository<ResourceApiRel, Long>, EntityGraphJpaSpecificationExecutor<ResourceApiRel> {
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Modifying(flushAutomatically = true, clearAutomatically = true)
    @Query("delete from ResourceApiRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Transactional(readOnly = true)
    long countByServiceApiId(long serviceApiId);

    @Transactional(readOnly = true)
    List<ResourceApiRel> findByServiceApiId(Long serviceApiId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying(flushAutomatically = true, clearAutomatically = true)
    @Query("delete from ResourceApiRel rel where rel.serviceApiId = :serviceApiId and rel.resourceId = :resourceId")
    void deleteByServiceApiIdAndResourceId(@Param("serviceApiId") long serviceApiId, @Param("resourceId") long resourceId);

    @Transactional(rollbackFor = Exception.class)
    @Modifying(flushAutomatically = true, clearAutomatically = true)
    @Query("delete from ResourceApiRel rel where rel.serviceApiId = :serviceApiId")
    void deleteByServiceApiId(@Param("serviceApiId") long serviceApiId);

    @Transactional(readOnly = true)
    List<ResourceApiRel> findByResourceId(Long resourceId);

    @Transactional(readOnly = true)
    @Query("select rel from ResourceApiRel rel where rel.resourceId = :resourceId and rel.serviceApiId <> :serviceApiId")
    List<ResourceApiRel> findByResourceIdAndNotServiceApiId(@Param("resourceId") long resourceId,
                                                            @Param("serviceApiId") long serviceApiId);
}
