package com.xforceplus.dao;

import com.xforceplus.entity.ServiceApi;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Collection;
import java.util.List;
import java.util.Set;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ServiceApiDao extends EntityGraphJpaRepository<ServiceApi, Long>, EntityGraphJpaSpecificationExecutor<ServiceApi> {
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Modifying(flushAutomatically = true, clearAutomatically = true)
    @Query("delete from ServiceApi s where s.serviceApiId = :id")
    void deleteById(@Param("id") Long id);

    List<ServiceApi> findBySkipAuthorizationEqualsAndStatusEquals(Boolean skipAuthorization, Integer status);

    @Query("select distinct sa from ServiceApi sa,ResourceApiRel rar,Resource r where " +
            "sa.serviceApiId = rar.serviceApiId and rar.resourceId = r.resourceId and  r.resourceCode = :resourceCode")
    List<ServiceApi> findServiceApiUrlsByResourceCode(@Param("resourceCode") String resourceCode);

    /**
     * 根据RouteId,serviceApiPath,RequestMethod 查询数据
     *
     * @param routeId       routeId
     * @param serviceApiUrl serviceApiUrl
     * @param requestMethod requestMethod
     * @return List<ServiceApi>
     */
    List<ServiceApi> findByRouteIdAndServiceApiUrlAndRequestMethod(Long routeId, String serviceApiUrl, RequestMethod requestMethod);


    /**
     * 按hash值查看是否已存在相同的ServiceApi
     *
     * @param hash
     * @return
     */
    long countByHash(String hash);

    /**
     * 按hash值查找已存在相同的ServiceApi
     *
     * @param hash
     * @return
     */
    List<ServiceApi> findByHash(String hash);

    @Query("select sa from ServiceApi sa where sa.hash in :hashes")
    List<ServiceApi> findByHashes(@Param("hashes") Collection<String> hashes);
}
