package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 自动扫描记录实体
 * @author geewit
 */
@Schema(description = "自动扫描记录实体")
@FieldNameConstants
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "autoscan_record")
@Setter
@ToString
public class AutoscanRecord implements Serializable {
    private Long autoscanRecordId;
    /**
     * 路由id集合, ','分割
     */
    @Schema(description = "路由id集合, ','分割")
    private String routeIds;

    /**
     * 路由地址集合, ','分割
     */
    @Schema(description = "路由地址集合, ','分割")
    private String routePaths;
    /**
     * 是否服务包, 是:需要和租户服务包交集
     */
    @Schema(description = "是否服务包, 是:需要和租户服务包交集")
    private Boolean isServicePackage;
    /**
     * 状态
     */
    @Schema(description = "状态")
    private Integer status;
    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @Id
    @Column(name = "autoscan_record_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getAutoscanRecordId() {
        return autoscanRecordId;
    }

    @Basic
    @Column(name = "route_ids")
    public String getRouteIds() {
        return routeIds;
    }

    @Basic
    @Column(name = "route_paths")
    public String getRoutePaths() {
        return routePaths;
    }

    @Basic
    @Column(name = "is_service_package")
    public Boolean getIsServicePackage() {
        return isServicePackage;
    }

    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }
}
