package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.ResourceApiRelListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * 资源码api关系实体
 * @author geewit
 */
@Schema(description = "资源码api关系实体")
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@EntityListeners({ResourceApiRelListener.class})
@Entity
@Table(name = "sys_resource_api_rel")
public class ResourceApiRel implements Serializable {
    private Long id;
    /**
     * 资源码id
     */
    @Schema(description = "资源码id")
    private Long resourceId;
    /**
     * 请求api的id
     */
    @Schema(description = "请求api的id")
    private Long serviceApiId;

    @JsonIgnore
    private Resource resource;

    @JsonIgnore
    private ServiceApi serviceApi;
    /**
     * 创建人名称
     */
    @Schema(description = "创建人名称")
    private String createUserName;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "resource_id", nullable = false)
    public Long getResourceId() {
        return (resourceId != null && resourceId > 0) ? resourceId : null;
    }

    @Basic
    @Column(name = "service_api_id", nullable = false)
    public Long getServiceApiId() {
        return (serviceApiId != null && serviceApiId > 0) ? serviceApiId : null;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "resource_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public Resource getResource() {
        return resource;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "service_api_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public ServiceApi getServiceApi() {
        return serviceApi;
    }

    @Basic
    @Column(name = "create_user_name")
    public String getCreateUserName() {
        return createUserName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceApiRel that = (ResourceApiRel) o;
        return resourceId.equals(that.resourceId) &&
                serviceApiId.equals(that.serviceApiId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, serviceApiId);
    }

    @Override
    public String toString() {
        return "ResourceApiRel{" +
                "id=" + id +
                ", resourceId=" + resourceId +
                ", serviceApiId=" + serviceApiId +
                ", createUserName='" + createUserName + '\'' +
                '}';
    }
}
