package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.route.RouteDto;
import com.xforceplus.jpa.listener.RouteListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.v3.oas.annotations.media.Schema;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 路由实体
 * @author geewit
 */
@Schema(description = "路由实体")
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@Audited
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_route")
@EntityListeners({RouteListener.class})
public class Route extends RouteDto implements Serializable {

    @Override
    @Id
    @Column(name = "route_id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getRouteId() {
        return routeId;
    }

    @Override
    @Basic
    @Column(name = "app_id")
    public Long getAppId() {
        return appId;
    }

    @Override
    @Basic
    @Column(name = "route_name")
    public String getRouteName() {
        return routeName;
    }

    @Override
    @Basic
    @Column(name = "path")
    public String getPath() {
        return path;
    }

    @Override
    @Basic
    @Column(name = "url")
    public String getUrl() {
        return url;
    }

    @Override
    @Basic
    @Column(name = "is_static")
    public Boolean getIsStatic() {
        return isStatic;
    }

    @Override
    @Basic
    @Column(name = "is_exact_match")
    public Boolean getIsExactMatch() {
        return isExactMatch;
    }

    @NotAudited
    @Override
    @Basic
    @Column(name = "operator")
    public Boolean getIsOperator() {
        return isOperator;
    }

    @Override
    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "group_type")
    public String getGroupType() {
        return groupType;
    }

    @Override
    @Basic
    @Column(name = "billable")
    public Boolean getBillable() {
        return billable;
    }

    @Override
    @Basic
    @Column(name = "skip_authentication")
    public Boolean getSkipAuthentication() {
        return skipAuthentication;
    }

    @Override
    @Basic
    @Column(name = "skip_authorization")
    public Boolean getSkipAuthorization() {
        return skipAuthorization;
    }

    @Override
    @Basic
    @Column(name = "hash")
    public String getHash() {
        return hash;
    }

    @Override
    @Basic
    @Column(name = "timeout")
    public Integer getTimeout() {
        return timeout;
    }

    @Override
    @Basic
    @Column(name = "enable_autoscan")
    public Boolean getEnableAutoscan() {
        return enableAutoscan;
    }

    @Override
    @Basic
    @Column(name = "force_authorize")
    public Boolean getForceAuthorize(){
        return forceAuthorize;
    }

    @Override
    @Basic
    @Column(name = "allow_client_id")
    public Boolean getAllowClientId(){
        return allowClientId;
    }

    @Override
    @Basic
    @Column(name = "contact")
    public String getContact(){
        return contact;
    }

    @Override
    @Basic
    @Column(name = "contact_team")
    public String getContactTeam(){
        return contactTeam;
    }

    @Override
    @Basic
    @Column(name = "health_path")
    public String getHealthPath() {
        return super.healthPath;
    }

    @NotAudited
    @Override
    @Basic
    @Column(name = "create_user_id")
    public String getCreateUserId() {
        return createUserId;
    }

    @NotAudited
    @Override
    @Basic
    @Column(name = "create_user_name")
    public String getCreateUserName() {
        return createUserName;
    }

    @Override
    @NotAudited
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }
}
