package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Route;
import com.xforceplus.entity.Route_;
import com.xforceplus.utils.RouteUtils;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.springframework.data.history.RevisionMetadata;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Objects;

/**
 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 @author geewit
 @since  2019-10-29
 */
public class RouteListener {
    @PrePersist
    public void prePersist(Route entity) {
        if(entity.getCreateUserId() == null) {
            IAuthorizedUser user = UserInfoHolder.get();
            if(user != null) {
                entity.setCreateUserId(String.valueOf(user.getId()));
                entity.setCreateUserName(user.getUsername());
            }
        }
        this.setHash(RevisionMetadata.RevisionType.INSERT, entity);
    }

    @PreUpdate
    public void preUpdate(Route entity) {
        this.setHash(RevisionMetadata.RevisionType.UPDATE, entity);
    }

    private void setHash(RevisionMetadata.RevisionType revisionType, Route entity) {
        boolean newPath = false;
        if (RevisionMetadata.RevisionType.INSERT.equals(revisionType)) {
            newPath = true;
        } else if (entity instanceof ManagedEntity) {
            EntityEntry entityEntry = ((ManagedEntity) entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                String prePath = (String) entityEntry.getLoadedValue(Route_.PATH);
                newPath = !Objects.equals(prePath, entity.getPath());
            } else {
                newPath = StringUtils.isNotBlank(entity.getPath());
            }
        }
        if(newPath || StringUtils.isBlank(entity.getHash())) {
            String hash = RouteUtils.hash(entity.getPath());
            entity.setHash(hash);
        }
    }
}