package com.xforceplus.jpa.listener;

import com.xforceplus.tenant.security.core.context.ClientInfoHolder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IUpdater;
import org.apache.commons.lang3.StringUtils;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public interface UpdaterListener<U extends IUpdater> {
    default void beforeUpdate(U entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setUpdaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setUpdaterName(authorizedUser.getOperaterName());
            } else {
                entity.setUpdaterName(StringUtils.EMPTY);
            }
        } else {
            //client token创建人和更新人设置为clientId
            String clientId = ClientInfoHolder.get();
            if (StringUtils.isNotEmpty(clientId)) {
                entity.setUpdaterName(clientId);
                entity.setUpdaterId(clientId);
            }
        }
    }
}
