/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.route.utils;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class ApiUtils {
    private static final Logger logger = LoggerFactory.getLogger(ApiUtils.class);
    private static final String PATH_VARIABLE_NAME_PREFIX = "variable";

    public static String replacePathVariable(String path, PathPatternParser pathPatternParser) {
        Map pathVariables;
        PathContainer pathContainer;
        PathPattern pathPattern = pathPatternParser.parse(path);
        PathPattern.PathMatchInfo pathMatchInfo = pathPattern.matchAndExtract(pathContainer = PathContainer.parsePath((String)path));
        if (pathMatchInfo != null && !(pathVariables = pathMatchInfo.getUriVariables()).isEmpty()) {
            logger.debug("path.variables: {} ", (Object)pathVariables);
            Map.Entry[] pathEntriesArray = new Map.Entry[path.length()];
            for (Map.Entry entry : pathVariables.entrySet()) {
                int index = StringUtils.indexOf((CharSequence)path, (CharSequence)((CharSequence)entry.getValue()));
                logger.debug("prePath entry.value = {}, index = {}", entry.getValue(), (Object)index);
                pathEntriesArray[index] = entry;
            }
            List pathVariableNames = Arrays.stream(pathEntriesArray).filter(Objects::nonNull).map(Map.Entry::getKey).collect(Collectors.toList());
            logger.debug("pathVariableNames = {}", pathVariableNames);
            HashMap newPathVariables = new HashMap(pathVariableNames.size());
            if (!pathVariableNames.isEmpty()) {
                for (int i = 0; i < pathVariableNames.size(); ++i) {
                    newPathVariables.put(pathVariableNames.get(i), "{variable" + (i + 1) + "}");
                }
                try {
                    String newPath = UriComponentsBuilder.fromPath((String)path).buildAndExpand(newPathVariables).getPath();
                    if (newPath == null) {
                        return path;
                    }
                    newPath = URLDecoder.decode(newPath, StandardCharsets.UTF_8.name());
                    return newPath;
                }
                catch (Exception ignored) {
                    return path;
                }
            }
        }
        return path;
    }
}

