package com.xforceplus;

import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.util.Properties;


/**
 * @author geewit
 */
@EnableCaching //开启spring cache
@EnableScheduling
@EnableFeignClients
@SpringBootApplication//自动开启@EnableAutoConfiguration
@PropertySource(value = {"classpath:env/${" + AbstractEnvironment.ACTIVE_PROFILES_PROPERTY_NAME + "}/application.properties"}, ignoreResourceNotFound = true, encoding = "UTF-8")
public class Bootstrap {

	public static void main(String[] args) {
		System.setProperty("log4j2.formatMsgNoLookups", "true");
		String profile = System.getProperty(AbstractEnvironment.ACTIVE_PROFILES_PROPERTY_NAME, "unknown");
		Properties properties = new Properties();
		if ("default".equals(profile)) {
			System.setProperty("log4j.skipJansi", "false");
			properties.put("logging.config", "classpath:env/default/log4j2.xml");
		} else if (StringUtils.containsAny(profile, "dev", "fat", "sit", "uat", "demo")) {
			properties.put("logging.config", "classpath:env/test/log4j2.xml");
		} else if (StringUtils.contains(profile, "prod")) {
			properties.put("logging.config", "classpath:env/prod/log4j2.xml");
		} else {
			properties.put("logging.config", "classpath:env/test/log4j2.xml");
		}
		SpringApplication application = new SpringApplication(Bootstrap.class);
		application.setDefaultProperties(properties);
		application.run(args);

	}
}
