package com.xforceplus.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;

import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 处理跨域
 * @author geewit
 */
@Configuration
public class CorsConfig {
    private static final long MAX_AGE = 3600L;

    @Bean
    public CorsConfiguration corsConfiguration() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowedMethods(Stream.of(CorsConfiguration.ALL).collect(Collectors.toList()));
        config.setAllowedOriginPatterns(Stream.of(CorsConfiguration.ALL).collect(Collectors.toList()));
        config.setAllowedOrigins(null);
        config.setAllowedHeaders(Stream.of(CorsConfiguration.ALL).collect(Collectors.toList()));
        config.setAllowCredentials(Boolean.FALSE);
        config.setMaxAge(MAX_AGE);
        return config;
    }

}