package com.xforceplus.config;

import io.geewit.data.jpa.essential.repository.support.EntityGraphJpaRepositoryFactoryBean;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;


/**
 * @author geewit
 * @since 2017-04-07
 */
@Configuration(proxyBeanMethods = false)
@EntityScan(basePackages = {"com.xforceplus.**.entity"})
@EnableJpaRepositories(basePackages = {"com.xforceplus.dao"}, repositoryFactoryBeanClass = EntityGraphJpaRepositoryFactoryBean.class)
@EnableAutoConfiguration
@EnableTransactionManagement
public class JpaConfig {
}
