package com.xforceplus.config;

import com.xforceplus.route.listener.MessagePublisher;
import com.xforceplus.route.listener.RedisMessagePublisher;
import com.xforceplus.route.listener.Topic;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;


@Configuration
public class RedisConfig {

    @Bean
    public ChannelTopic topic() {
        return new ChannelTopic(Topic.name);
    }

    @Bean
    public MessagePublisher redisPublisher(StringRedisTemplate redisTemplate) {
        return new RedisMessagePublisher(redisTemplate, topic());
    }

}
