package com.xforceplus.config;

import org.hibernate.validator.HibernateValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.beanvalidation.SpringConstraintValidatorFactory;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

/**
 * hibernate.validator.fail_fast
 * true  快速失败返回模式    false 普通模式
 * 遇到第一个错误就返回
 * https://docs.jboss.org/hibernate/validator/4.2/reference/en-US/html/validator-specifics.html
 * @author geewit
 */
@Configuration
public class ValidatorConfig {
    @Autowired
    private AutowireCapableBeanFactory autowireCapableBeanFactory;

    @Bean
    public Validator validator() {
        ValidatorFactory validatorFactory = Validation.byProvider(HibernateValidator.class)
                .configure()
                .constraintValidatorFactory(new SpringConstraintValidatorFactory(autowireCapableBeanFactory))
                .addProperty("hibernate.validator.fail_fast", Boolean.FALSE.toString())
                .buildValidatorFactory();
        return validatorFactory.getValidator();
    }
}