package com.xforceplus.jackson.databind.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import org.springframework.boot.jackson.JsonComponent;

import java.io.IOException;


/**
 * @author geewit
 */
@JsonComponent
public class ResponseEntitySerializer extends JsonSerializer<ResponseEntity> {
    private final ObjectMapper mapper;

    public ResponseEntitySerializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void serialize(ResponseEntity value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("code");
        generator.writeString(value.getCode());
        generator.writeFieldName("message");
        generator.writeString(value.getMessage());
        if (value.getResult() != null) {
            generator.writeFieldName("result");
            boolean defaultViewInclusionEnabled = mapper.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
            if(defaultViewInclusionEnabled) {
                mapper.disable(MapperFeature.DEFAULT_VIEW_INCLUSION);
            }
            String json = mapper.writerWithView(provider.getActiveView()).writeValueAsString(value.getResult());
            if(defaultViewInclusionEnabled) {
                mapper.enable(MapperFeature.DEFAULT_VIEW_INCLUSION);
            }
            generator.writeRawValue(json);
        }
        generator.writeEndObject();
    }
}
