package com.xforceplus.route.service;

import com.xforceplus.dao.AutoscanRecordDao;
import com.xforceplus.entity.AutoscanRecord;
import com.xforceplus.route.constants.AutoscanStatus;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.concurrent.TimeUnit;


/**
 * 自动扫描Service
 *
 * @author lengmz
 */
@SuppressWarnings("all")
@Service
@Slf4j
public class AutoscanRecordService {

    private final static String REDIS_PREFIX = "XF_AUTOSCAN_";

    private final AutoscanRecordDao autoscanRecordDao;

    private final RedisTemplate<String, String> redisTemplate;

    public AutoscanRecordService(AutoscanRecordDao autoscanRecordDao, RedisTemplate<String, String> redisTemplate) {
        this.autoscanRecordDao = autoscanRecordDao;
        this.redisTemplate = redisTemplate;
    }

    @Transactional(rollbackFor = Exception.class)
    public AutoscanRecord save(String routeIds, Boolean isServicePackage) {
        String key = REDIS_PREFIX + routeIds.trim().replace(",", "_");
        boolean result = redisTemplate.opsForValue().setIfAbsent(key, "exists", 10, TimeUnit.MINUTES);
        AutoscanRecord autoscanRecord = new AutoscanRecord();
        autoscanRecord.setRouteIds(routeIds);
        autoscanRecord.setIsServicePackage(isServicePackage);
        if (result) {
            autoscanRecord.setStatus(AutoscanStatus.CREATED);
        } else {
            autoscanRecord.setStatus(AutoscanStatus.INVALID);
        }
        autoscanRecord.setCreateTime(new Date());
        autoscanRecord.setUpdateTime(new Date());
        return autoscanRecordDao.saveAndFlush(autoscanRecord);
    }

    @Transactional(rollbackFor = Exception.class)
    public AutoscanRecord updateStatus(AutoscanRecord autoscanRecord) {
        autoscanRecord.setUpdateTime(new Date());
        return autoscanRecordDao.saveAndFlush(autoscanRecord);
    }

}
