/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Profile(value={"!default"})
@Configuration
public class ApolloEventListener {
    private static final Logger log = LoggerFactory.getLogger(ApolloEventListener.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RefreshScope refreshScope;

    @ApolloConfigChangeListener
    public void apolloChangeListener(ConfigChangeEvent changeEvent) {
        this.applicationContext.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(changeEvent.changedKeys()));
        this.refreshScope.refreshAll();
        changeEvent.changedKeys().forEach(key -> log.info("properties refresh:{}-->oldValue:{},newValue:{}", new Object[]{key, changeEvent.getChange(key).getOldValue(), changeEvent.getChange(key).getNewValue()}));
    }
}

