/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.config;

import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.okhttp.OkHttpClient;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Feign.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
public class FeignOkHttpConfig {
    @Bean
    Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    public Client feignClient() {
        return new OkHttpClient(this.okHttpClient());
    }

    private okhttp3.OkHttpClient okHttpClient() {
        return new OkHttpClient.Builder().readTimeout(300L, TimeUnit.SECONDS).connectTimeout(300L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).connectionPool(new ConnectionPool()).build();
    }
}

