/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jackson.databind.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import java.io.IOException;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class ResponseEntitySerializer
extends JsonSerializer<ResponseEntity> {
    private final ObjectMapper mapper;

    public ResponseEntitySerializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void serialize(ResponseEntity value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("code");
        generator.writeString(value.getCode());
        generator.writeFieldName("message");
        generator.writeString(value.getMessage());
        if (value.getResult() != null) {
            generator.writeFieldName("result");
            boolean defaultViewInclusionEnabled = this.mapper.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
            if (defaultViewInclusionEnabled) {
                this.mapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
            }
            String json = this.mapper.writerWithView(provider.getActiveView()).writeValueAsString(value.getResult());
            if (defaultViewInclusionEnabled) {
                this.mapper.enable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
            }
            generator.writeRawValue(json);
        }
        generator.writeEndObject();
    }
}

