/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route;

import io.geewit.core.exception.ProcessedException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HttpCheckUtils {
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(?i)(http|https):(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)(:(\\d*(?:\\{[^/]+?\\})?))?)?([^?#]*)(\\?(.*))?");

    public static void checkHttpUrl(String httpUrl) {
        Assert.notNull((Object)httpUrl, (String)"Url\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Matcher matcher = HTTP_URL_PATTERN.matcher(httpUrl);
        if (matcher.matches()) {
            String scheme = matcher.group(1);
            String host = matcher.group(5);
            if (StringUtils.hasLength((String)scheme) && !StringUtils.hasLength((String)host)) {
                throw new ProcessedException("[" + httpUrl + "] \u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684url");
            }
        } else {
            throw new ProcessedException("[" + httpUrl + "] \u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684url");
        }
    }
}

