/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.controller;

import com.xforceplus.entity.RouteApply;
import com.xforceplus.route.HttpCheckUtils;
import com.xforceplus.route.api.common.model.RouteModel;
import com.xforceplus.route.service.RouteApplyService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import com.xforceplus.utils.RouteUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.domain.SortFactory;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/global/route-apply"})
public class RouteApplyController {
    private static final Logger logger = LoggerFactory.getLogger(RouteApplyController.class);
    @Resource
    private RouteApplyService routeApplyService;

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u8def\u7531\u5217\u8868", value={""}, method={RequestMethod.GET})
    public ResponseEntity<List<RouteApply>> list(Sort sort) {
        Sort currentSort = SortFactory.ofDefaultSort((Sort)sort, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"path"}));
        List<RouteApply> list = this.routeApplyService.findAll(currentSort);
        return ResponseEntity.ok(list);
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u8def\u7531\u5206\u9875\u5217\u8868", value={"/page"}, method={RequestMethod.GET})
    public ResponseEntity<Page<RouteApply>> page(Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"path"}));
        Page<RouteApply> page = this.routeApplyService.findAll(currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u65b0\u589e\u8def\u7531\u7533\u8bf7", value={""}, method={RequestMethod.POST})
    public ResponseEntity<RouteApply> create(RouteModel.Request.Save routeForm) {
        this.checkCreatePara(routeForm);
        if (StringUtils.isBlank((CharSequence)routeForm.getPath())) {
            throw new IllegalArgumentException("\u5339\u914d\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String hash = RouteUtils.hash((String)routeForm.getPath());
        routeForm.setHash(hash);
        long count = this.routeApplyService.countByHash(hash);
        if (count > 0L) {
            String message = "\u91cd\u590d\u7684\u5339\u914d\u8def\u5f84(" + routeForm.getPath() + ")";
            throw new IllegalArgumentException(message);
        }
        RouteApply route = new RouteApply();
        BeanUtils.copyProperties((Object)routeForm, (Object)route);
        route = this.routeApplyService.create(route);
        return ResponseEntity.ok((Object)route);
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u66f4\u65b0\u8def\u7531", value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<RouteApply> update(Long id, RouteModel.Request.Save routeForm) {
        this.checkUpdatePara(routeForm);
        RouteApply route = new RouteApply();
        BeanUtils.copyProperties((Object)routeForm, (Object)route);
        route = this.routeApplyService.update(id, route);
        return ResponseEntity.ok((Object)route);
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u5220\u9664\u8def\u7531", value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> delete(Long id) {
        this.routeApplyService.delete(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u66f4\u6539\u72b6\u6001", value={"/{id}/status/{status}"}, method={RequestMethod.PUT})
    public ResponseEntity<RouteApply> status(@PathVariable(value="id") Long id, @PathVariable(value="status") Integer status) {
        RouteApply routeApply = this.routeApplyService.changeStatus(id, status);
        return ResponseEntity.ok((Object)routeApply);
    }

    private void checkCreatePara(RouteModel.Request.Save routeForm) {
        Assert.notNull((Object)routeForm.getAppId(), (String)"appId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.notNull((Object)routeForm.getPath(), (String)"\u5339\u914d\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.notNull((Object)routeForm.getRouteName(), (String)"\u8def\u7531\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        HttpCheckUtils.checkHttpUrl(routeForm.getUrl());
    }

    private void checkUpdatePara(RouteModel.Request.Save routeForm) {
        if (StringUtils.isNotBlank((CharSequence)routeForm.getUrl())) {
            HttpCheckUtils.checkHttpUrl(routeForm.getUrl());
        }
    }
}

