/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.controller;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.xforceplus.api.global.autoscan.AutoscanApi;
import com.xforceplus.domain.route.RouteDto;
import com.xforceplus.entity.AutoscanRecord;
import com.xforceplus.entity.Route;
import com.xforceplus.route.api.RouteApi;
import com.xforceplus.route.api.common.model.RouteModel;
import com.xforceplus.route.constants.AutoscanStatus;
import com.xforceplus.route.service.AutoscanRecordService;
import com.xforceplus.route.service.RouteService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.autoscan.model.AutoScanBody;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import com.xforceplus.utils.RouteUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.domain.SortFactory;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Validated
@Controller
public class RouteController
implements RouteApi,
AutoscanApi {
    private static final Logger logger = LoggerFactory.getLogger(RouteController.class);
    ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("tenant-autoscan-pool-%d").build();
    private final AutoscanRecordService autoscanRecordService;
    private final RouteService routeService;
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this.namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());

    public RouteController(RouteService routeService, AutoscanRecordService autoscanRecordService) {
        this.routeService = routeService;
        this.autoscanRecordService = autoscanRecordService;
    }

    @AuthorizedDefinition(authorization=false)
    public ResponseEntity<List<Route>> list(RouteModel.Request.Query query, Sort sort) {
        Sort currentSort = SortFactory.ofDefaultSort((Sort)sort, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"path"}));
        List<Route> result = this.routeService.findAll(query, currentSort);
        for (Route route : result) {
            RouteUtils.reRenderRoute((RouteDto)route);
        }
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(authorization=false)
    public ResponseEntity<Page<Route>> page(RouteModel.Request.Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"path"}));
        Page<Route> result = this.routeService.findAll(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(authorization=false)
    public ResponseEntity<Route> create(RouteModel.Request.Save routeForm) {
        if (StringUtils.isBlank((CharSequence)routeForm.getPath())) {
            throw new IllegalArgumentException("\u5339\u914d\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        routeForm.setPath(StringUtils.trim((String)routeForm.getPath()));
        routeForm.setUrl(StringUtils.trim((String)routeForm.getUrl()));
        String hash = RouteUtils.hash((String)routeForm.getPath());
        long count = this.routeService.countByHash(hash);
        if (count > 0L) {
            String message = "\u91cd\u590d\u7684\u5339\u914d\u8def\u5f84(" + routeForm.getPath() + ")";
            throw new IllegalArgumentException(message);
        }
        routeForm.setHash(hash);
        Route result = new Route();
        BeanUtils.copyProperties((Object)routeForm, (Object)result);
        result = this.routeService.create(result);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(authorization=false)
    public ResponseEntity<Route> update(Long id, RouteModel.Request.Save routeForm) {
        Route result = new Route();
        if (StringUtils.isNotBlank((CharSequence)routeForm.getPath())) {
            routeForm.setPath(StringUtils.trim((String)routeForm.getPath()));
        }
        if (StringUtils.isNotBlank((CharSequence)routeForm.getUrl())) {
            routeForm.setUrl(StringUtils.trim((String)routeForm.getUrl()));
        }
        BeanUtils.copyProperties((Object)routeForm, (Object)result);
        result = this.routeService.update(id, result);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(authorization=false)
    public ResponseEntity<String> delete(Long id) {
        this.routeService.delete(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u5237\u65b0\u8def\u7531Hash", value={"${xforce.route.service.url.prefix:/api}/global${xforce.route.service.version:}/routes/refresh/hash"}, method={RequestMethod.POST})
    public ResponseEntity<String> refreshHash() {
        this.routeService.refreshHash();
        return ResponseEntity.ok((Object)"\u5237\u65b0\u6210\u529f");
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u5237\u65b0\u8def\u7531", value={"${xforce.route.service.url.prefix:/api}/global${xforce.route.service.version:}/routes/refresh"}, method={RequestMethod.POST})
    public String refresh() {
        return this.routeService.refresh();
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u5237\u65b0\u8def\u7531", value={"${xforce.route.service.url.prefix:/api}/global${xforce.route.service.version:}/routes/refresh/{refreshId}"}, method={RequestMethod.GET})
    public String refreshCount(@PathVariable(value="refreshId") String refreshId) {
        return this.routeService.getRefreshCount(refreshId);
    }

    @AuthorizedDefinition(authorization=false)
    @ApiOperation(value="\u6839\u636e\u8def\u7531id\u626b\u63cf\u63a5\u53e3", notes="\u6839\u636e\u8def\u7531id\u626b\u63cf\u63a5\u53e3")
    public ResponseEntity<String> scan(@PathVariable Long routeId) {
        this.executorService.submit(() -> {
            try {
                logger.info("\u5f00\u59cb\u6267\u884c\u3002");
                this.routeService.scanResource(routeId);
            }
            catch (Exception e) {
                logger.error("\u6267\u884c\u62a5\u9519\u3002", (Throwable)e);
            }
        });
        return ResponseEntity.okWithCode((Object)"\u6210\u529f");
    }

    @AuthorizedDefinition(authorization=false)
    @ApiOperation(value="\u6279\u91cf\u626b\u63cf\u63a5\u53e3", notes="\u6279\u91cf\u626b\u63cf\u63a5\u53e3")
    public ResponseEntity<String> batchScan(@RequestBody AutoScanBody autoScanBody) {
        if (StringUtils.isBlank((CharSequence)autoScanBody.getRouteIds())) {
            return ResponseEntity.ok((Object)"\u5165\u53c2\u6709\u8bef");
        }
        AutoscanRecord autoscanRecord = this.autoscanRecordService.save(autoScanBody.getRouteIds(), autoScanBody.getIsServicePackage());
        if (AutoscanStatus.CREATED.equals(autoscanRecord.getStatus())) {
            this.executorService.submit(() -> {
                try {
                    HashSet<Long> routeIds = new HashSet<Long>();
                    if (StringUtils.isNotBlank((CharSequence)autoScanBody.getRouteIds())) {
                        Arrays.stream(StringUtils.split((String)autoScanBody.getRouteIds(), (String)",")).forEach(id -> {
                            try {
                                Long parseLong = Long.parseLong(id);
                                routeIds.add(parseLong);
                            }
                            catch (NumberFormatException e) {
                                String message = e.getMessage() + ", id: " + id;
                                logger.warn(message);
                            }
                        });
                    }
                    if (!routeIds.isEmpty()) {
                        try {
                            this.routeService.scanResourceByRequest(routeIds, autoScanBody);
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                    autoscanRecord.setStatus(AutoscanStatus.DONE);
                    this.autoscanRecordService.updateStatus(autoscanRecord);
                }
                catch (Exception e) {
                    autoscanRecord.setStatus(AutoscanStatus.FAILED);
                    this.autoscanRecordService.updateStatus(autoscanRecord);
                    logger.error("\u6267\u884c\u62a5\u9519", (Throwable)e);
                }
            });
        }
        return ResponseEntity.okWithCode((Object)"\u6210\u529f");
    }
}

