/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.controller;

import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.route.api.ServiceApiApi;
import com.xforceplus.route.api.common.model.ResourceModel;
import com.xforceplus.route.api.common.model.ServiceApiModel;
import com.xforceplus.route.service.ResourceService;
import com.xforceplus.route.service.ServiceApiService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import com.xforceplus.utils.ApiUtils;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.geewit.data.jpa.essential.search.DynamicSpecifications;
import io.geewit.data.jpa.essential.search.SearchFilter;
import io.geewit.data.jpa.essential.web.servlet.Servlets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import springfox.documentation.annotations.ApiIgnore;

@Controller
public class ServiceApiController
implements ServiceApiApi {
    private final ServiceApiService serviceApiService;
    private final ResourceService resourceService;

    public ServiceApiController(ServiceApiService serviceApiService, ResourceService resourceService) {
        this.serviceApiService = serviceApiService;
        this.resourceService = resourceService;
    }

    @AuthorizedDefinition(authorization=false)
    public ResponseEntity<Map<Long, Set<ServiceApiModel.Response.ServiceApiWithResource>>> list() {
        Map<Long, Set<ServiceApiModel.Response.ServiceApiWithResource>> result = this.serviceApiService.all();
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:read"})
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u63a5\u53e3\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u670d\u52a1\u63a5\u53e3\u5206\u9875")
    @ResponseBody
    @RequestMapping(name="\u670d\u52a1\u63a5\u53e3\u5206\u9875\u5217\u8868\u67e5\u8be2", value={"${xforce.route.service.url.prefix:/api}/global${xforce.route.service.version:}/service-apis/query"}, method={RequestMethod.GET})
    public Page<ServiceApi> page(WebRequest request, @ApiParam(value="pageable") Pageable pageable) {
        Map searchParams = Servlets.getParametersStartingWith((WebRequest)request, (String)"search_");
        Collection filters = SearchFilter.parse((Map)searchParams);
        Specification specification = DynamicSpecifications.bySearchFilter((Collection)filters);
        Page<ServiceApi> page = this.serviceApiService.page((Specification<ServiceApi>)specification, pageable);
        return page;
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:read"})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u63a5\u53e3\u5206\u9875", notes="\u901a\u8fc7\u5206\u9875\u53c2\u6570\uff0c\u83b7\u53d6\u670d\u52a1\u63a5\u53e3\u5206\u9875")
    public ResponseEntity<Page<ServiceApi>> page(@ApiParam(value="request") ServiceApiModel.Request.Query query, @ApiParam(value="pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page<ServiceApi> result = this.serviceApiService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:save"})
    @ApiOperation(value="\u65b0\u5efa\u670d\u52a1\u63a5\u53e3")
    public ResponseEntity<ServiceApi> create(ServiceApiModel.Request.Save model) {
        long count;
        if (model.getServiceApiPath() == null) {
            throw new IllegalArgumentException("ServiceApiPath \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)model.getServiceApiUrl())) {
            throw new IllegalArgumentException("ServiceApiUrl \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (model.getRequestMethod() == null) {
            throw new IllegalArgumentException("RequestMethod \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String hash = model.getHash();
        if (StringUtils.isBlank((CharSequence)hash)) {
            hash = ApiUtils.hash((String)model.getServiceApiUrl(), (String)model.getRequestMethod().name(), (Long)model.getRouteId());
        }
        if ((count = this.serviceApiService.countByHash(hash)) > 0L) {
            String message = "\u5b58\u5728\u91cd\u590d\u7684ServiceApi(path:" + model.getServiceApiUrl() + ", method:" + model.getRequestMethod() + ", routeId:" + model.getRouteId() + ")";
            throw new IllegalArgumentException(message);
        }
        model.setHash(hash);
        ServiceApi result = this.serviceApiService.save(model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:read"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u670d\u52a1\u63a5\u53e3")
    public ResponseEntity<ServiceApi> info(@ApiParam(value="id", required=true) long id) {
        ServiceApi result = this.serviceApiService.findById(id);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:save"})
    @ApiOperation(value="\u6839\u636eid\u66f4\u65b0\u670d\u52a1\u63a5\u53e3")
    public ResponseEntity<ServiceApi> update(@ApiParam(value="id", required=true) long id, @ApiParam(value="model", required=true) ServiceApiModel.Request.Update model) {
        ServiceApi result = this.serviceApiService.update(id, model);
        return ResponseEntity.ok((Object)result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:save"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u670d\u52a1\u63a5\u53e3")
    public ResponseEntity<String> delete(@ApiParam(value="id", required=true) long id) {
        this.serviceApiService.deleteById(id);
        return ResponseEntity.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:read"})
    @ApiOperation(value="\u670d\u52a1\u5305\u63a5\u53e3\u5bf9\u5e94\u7684\u8d44\u6e90\u7801\u5206\u9875\u5217\u8868")
    public ResponseEntity<Page<Resource>> resources(@ApiParam(value="\u63a5\u53e3id") long id, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort((Pageable)pageable, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        ServiceApi serviceApi = this.serviceApiService.findById(id);
        ResourceModel.Request.Query query = new ResourceModel.Request.Query();
        query.setServiceApiId(serviceApi.getServiceApiId());
        Page<Resource> result = this.resourceService.page(query, currentPageable);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:read"})
    @ApiOperation(value="\u63a5\u53e3\u6279\u91cf\u7ed1\u5b9a\u8d44\u6e90\u7801\u96c6\u5408")
    public ResponseEntity<String> bindResources(@ApiParam(value="\u63a5\u53e3id") long id, ServiceApiModel.Request.BindResources bindResources) {
        this.serviceApiService.bindResources(id, bindResources);
        return ResponseEntity.ok((Object)"\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(resources={"xforce:operation:serviceApi:save"})
    @ApiOperation(value="\u63a5\u53e3\u53cd\u7ed1\u5b9a\u8d44\u6e90\u7801")
    public ResponseEntity<String> unbindResource(long serviceApiId, long resourceId) {
        this.serviceApiService.unbindServiceApiResourceRel(serviceApiId, resourceId);
        return ResponseEntity.ok((Object)"\u53cd\u7ed1\u5b9a\u6210\u529f");
    }

    @AuthorizedDefinition(authorization=false)
    @ResponseBody
    @RequestMapping(name="\u5237\u65b0\u63a5\u53e3Hash", value={"${xforce.route.service.url.prefix:/api}/global${xforce.route.service.version:}/service-apis/refresh/hash"}, method={RequestMethod.POST})
    public ResponseEntity<String> refreshHash(@RequestParam(value="routeId", required=false) Long routeId) {
        if (routeId != null && routeId > 0L) {
            this.serviceApiService.refreshHashByRouteId(routeId);
        } else {
            this.serviceApiService.refreshHash();
        }
        return ResponseEntity.ok((Object)"\u5237\u65b0\u6210\u529f");
    }
}

