/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.listener;

import com.xforceplus.route.listener.MessagePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;

public class RedisMessagePublisher
implements MessagePublisher {
    private static final Logger log = LoggerFactory.getLogger(RedisMessagePublisher.class);
    private final StringRedisTemplate redisTemplate;
    private final ChannelTopic topic;

    public RedisMessagePublisher(StringRedisTemplate redisTemplate, ChannelTopic topic) {
        this.redisTemplate = redisTemplate;
        this.topic = topic;
    }

    @Override
    public void publish(String message) {
        log.debug("refresh route message = {} publish", (Object)message);
        this.redisTemplate.convertAndSend(this.topic.getTopic(), (Object)message);
    }
}

